/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.IAmmoProvider;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoMaterialManager;
import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import dev.toma.gunsrpg.util.Lifecycle;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.locate.ILocatorPredicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class C2S_SelectAmmoPacket
extends AbstractNetworkPacket<C2S_SelectAmmoPacket> {
    private IAmmoMaterial material;

    public C2S_SelectAmmoPacket() {
    }

    public C2S_SelectAmmoPacket(IAmmoMaterial material) {
        this.material = material;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.material.getMaterialID());
    }

    @Override
    public C2S_SelectAmmoPacket decode(PacketBuffer buffer) {
        IAmmoMaterial material = AmmoMaterialManager.get().findMaterial(buffer.func_192575_l());
        return new C2S_SelectAmmoPacket(material);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof GunItem) {
            GunItem gun = (GunItem)stack.func_77973_b();
            int ammo = gun.getAmmo(stack);
            IAmmoMaterial oldMaterial = gun.getMaterialFromNBT(stack);
            if (oldMaterial != null && ammo > 0) {
                this.clearWeapon((PlayerEntity)player, gun, stack, ammo);
            }
            CompoundNBT data = stack.func_77978_p();
            data.func_74778_a("material", this.material.getMaterialID().toString());
        }
    }

    private void clearWeapon(PlayerEntity player, GunItem gun, ItemStack stack, int ammoAmount) {
        Item item = null;
        ILocatorPredicate<IAmmoProvider> predicate = provider -> provider.getAmmoType() == gun.getAmmoType() && provider.getMaterial() == gun.getMaterialFromNBT(stack);
        Lifecycle lifecycle = GunsRPG.getModLifecycle();
        for (IAmmoProvider ammo : lifecycle.getAllCompatibleAmmoProviders(gun)) {
            if (!predicate.isValidResult(ammo)) continue;
            item = (Item)ammo;
            break;
        }
        if (item != null) {
            ItemStack returnAmmo = new ItemStack(item, ammoAmount);
            ModUtils.addItem(player, returnAmmo);
            gun.setAmmoCount(stack, 0);
        }
    }
}

